% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.ind.r
\name{gl.dist.ind}
\alias{gl.dist.ind}
\title{Calculates a distance matrix for individuals defined in a genlight object}
\usage{
gl.dist.ind(
  x,
  method = NULL,
  scale = FALSE,
  swap = FALSE,
  output = "dist",
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight containing the SNP genotypes or presence-absence data [required].}

\item{method}{Specify distance measure [SNP: Euclidean; P/A: Simple].}

\item{scale}{If TRUE, the distances are scaled to fall in the range [0,1] [default TRUE]}

\item{swap}{If TRUE and working with presence-absence data, then presence 
(no disrupting mutation) is scored as 0 and absence (presence of a disrupting 
mutation) is scored as 1 [default FALSE].}

\item{output}{Specify the format and class of the object to be returned, 
'dist' for a object of class dist, 'matrix' for an object of class matrix [default "dist"].}

\item{plot.out}{If TRUE, display a histogram and a boxplot of the genetic distances [TRUE].}

\item{plot_theme}{User specified theme [default theme_dartR].}

\item{plot_colors}{Vector with two color names for the borders and fill [default two_colors].}

\item{save2tmp}{If TRUE, saves any ggplots to the session temporary directory [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
An object of class 'matrix' or dist' giving distances between individuals
}
\description{
This script calculates various distances between individuals based on allele
 frequencies or presence-absence data
}
\details{
The distance measure for SNP genotypes can be one of:
\itemize{
 \item Euclidean Distance [method = "Euclidean"]
 \item Scaled Euclidean Distance [method='Euclidean", scale=TRUE]
 \item Simple Mismatch Distance [method="Simple"]
 \item Absolute Mismatch Distance [method="Absolute"]
 \item Czekanowski (Manhattan) Distance [method="Manhattan"]
 }

The distance measure for Sequence Tag Presence/Absence data (binary) can be one of:
\itemize{
 \item Euclidean Distance [method = "Euclidean"]
 \item Scaled Euclidean Distance [method='Euclidean", scale=TRUE]
 \item Simple Matching Distance [method="Simple"]
 \item Jaccard Distance [method="Jaccard"]
 \item Bray-Curtis Distance [method="Bray-Curtis"]
 }

Refer to the dartR Technical Note on Distances in Genetics.
}
\examples{
 \donttest{
D <- gl.dist.ind(testset.gl[1:20,], method='manhattan')
D <- gl.dist.ind(testset.gs[1:20,], method='Jaccard',swap=TRUE)
}
D <- gl.dist.ind(testset.gl[1:20,], method='euclidean',scale=TRUE)
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to #' \url{https://groups.google.com/d/forum/dartr}
}
