% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getimpactedarea.R
\name{getimpactedarea}
\alias{getimpactedarea}
\title{getimpactedarea}
\usage{
getimpactedarea(
  reservoir,
  water_bodies = NULL,
  dem,
  fac,
  basins,
  pourpoints,
  toprocess = TRUE,
  espg = 4326,
  toadjust = FALSE,
  poss_expand = 20000,
  river_distance = 1e+05,
  nn = 100,
  ac_tolerance = 2,
  e_tolerance = 5,
  streambuffersize = 2000,
  reservoirbuffersize = 5000,
  wbjc = 0
)
}
\arguments{
\item{reservoir}{An sf polygon, with an unstandardised raw reservoir}

\item{water_bodies}{A rast, where 1 indicates water, NA otherwise. Required if toadjust == TRUE.}

\item{dem}{A rast, showing elevation}

\item{fac}{A rast, showing accumulated water flow along river}

\item{basins}{An sf multipolygon, with the basins in the area around the dam}

\item{pourpoints}{An sf multipoint, showing the points where rivers flow in and out of reservoirs}

\item{toprocess}{Whether to reprocess input data from 4326 to UTM (the default for consistency)}

\item{espg}{In case processing to UTM or other CRS has been done (not making use of preprocessing) the espg code to include}

\item{toadjust}{A true/false parameter whether to adjust the reservoir to surrounding water bodies}

\item{poss_expand}{A number, indicating the number of meters away from the raw reservoir the reservoir may expand to. Default is 20000 (20km).}

\item{river_distance}{A number, indicating the number of meters downstream and upstream for the area of interest. Defaults to 100000 (100km)}

\item{nn}{A number, indicating the number of nearest neighbours to consider in the algorithm to determine river course. Higher can be more accurate but is slower. Default 100.}

\item{ac_tolerance}{A number, indicating the tolerance to changes in flow accumulation. Default 2, which means that if accumulated flow changes by a factor of 2 (halved or doubled) the area of interest should not include any further downstream or upstream. This is to account for confluences.}

\item{e_tolerance}{A number indicating the tolerance to changes in elevation. Rivers flow downstream. But DEMs can show downstream areas of the river as higher, due to averaging nearby pixels. This is particularly true when rivers run through gorges. If there is no downstream lower river poitn nearby, the elevation tolerance allows the algorithm to select a point at a higher elevation, up to the threshold defined here.}

\item{streambuffersize}{A number indicating the distance around the upstream and downstream river to consider as impacted. Defaults to 2000 (2km).}

\item{reservoirbuffersize}{A number indicating the distance around the reserviur to consider as impacted. Defaults to 5000 (5km)}

\item{wbjc}{A number, the water body join correction. This indicates the buffer zone for the reservoir, to ensure that it is contiguous (important where there are small channels connecting different parts of the same water body). Default is 0, but is necessary for some dams depending on the context.}
}
\value{
An sf multipolygon with the reservoir buffer, upstream and downstream areas
}
\description{
Performs 1) standardisation of reservoir extent, 2) calculation of river course upstream and downstream and 3) clipping to river basins
}
