% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_dt_pca.R
\name{dt_pca}
\alias{dt_pca}
\title{PCA}
\usage{
dt_pca(attribute = NULL, components = NULL)
}
\arguments{
\item{attribute}{target attribute to model building}

\item{components}{number of components for PCA}
}
\value{
returns an object of class \code{dt_pca}
}
\description{
Principal Component Analysis (PCA) for unsupervised dimensionality reduction.
Transforms correlated variables into orthogonal principal components ordered by explained variance.
}
\details{
Fits PCA on (optionally) the numeric predictors only (excluding \code{attribute} when provided),
removes constant columns, and selects the number of components by an elbow rule (minimum curvature)
unless \code{components} is set explicitly.
}
\examples{
mypca <- dt_pca("Species")
# Automatically fitting number of components
mypca <- fit(mypca, iris)
iris.pca <- transform(mypca, iris)
head(iris.pca)
head(mypca$pca.transf)
# Manual establishment of number of components
mypca <- dt_pca("Species", 3)
mypca <- fit(mypca, datasets::iris)
iris.pca <- transform(mypca, iris)
head(iris.pca)
head(mypca$pca.transf)
}
\references{
Pearson, K. (1901). On lines and planes of closest fit to systems of points in space.
Hotelling, H. (1933). Analysis of a complex of statistical variables into principal components.
}
