% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\title{Transform observation variables.}
\usage{
transform(population, variables, operation = "generalized_log", ...)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{variables}{character vector specifying observation variables.}

\item{operation}{optional character string specifying method for transform. This must be one of the strings \code{"generalized_log"} (default), \code{"whiten"}.}

\item{...}{arguments passed to transformation operation.}
}
\value{
transformed data of the same class as \code{population}.
}
\description{
\code{transform} transforms observation variables based on the specified transformation method.
}
\examples{
population <- tibble::tibble(
  Metadata_Well = c("A01", "A02", "B01", "B02"),
  Intensity_DNA = c(8, 20, 12, 32)
)
variables <- c("Intensity_DNA")
transform(population, variables, operation = "generalized_log")
}
