% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt_wrapper.R
\name{encrypt}
\alias{encrypt}
\alias{decrypt}
\alias{encrypt_}
\alias{decrypt_}
\title{Easy encryption and decryption}
\usage{
encrypt(expr, key, file_arg = NULL, envir = parent.frame())

decrypt(expr, key, file_arg = NULL, envir = parent.frame())

encrypt_(expr, key, file_arg = NULL, envir = parent.frame())

decrypt_(expr, key, file_arg = NULL, envir = parent.frame())
}
\arguments{
\item{expr}{A single expression representing a function call that
would be called for the side effect of creating or reading a
file.}

\item{key}{A \code{cyphr_key} object describing the
encryption approach to use.}

\item{file_arg}{Optional hint indicating which argument to
\code{expr} is the filename.  This is done automatically for
some built-in functions.}

\item{envir}{Environment in which \code{expr} is to be evaluated.}
}
\description{
Wrapper functions for encryption.  These functions wrap
expressions that produce or consume a file and arrange to encrypt
(for producing functions) or decrypt (for consuming functions).
The forms with a trailing underscore (\code{encrypt_},
\code{decrypt_}) do not use any non-standard evaluation and may be
more useful for programming.
}
\details{
These functions will not work for all functions.  For example
\code{pdf}/\code{dev.off} will create a file but we can't wrap
those up (yet!).  Functions that \emph{modify} a file (e.g.,
appending) also will not work and may cause data loss.
}
\examples{
# To do anything we first need a key:
key <- cyphr::key_sodium(sodium::keygen())

# Encrypted write.csv - note how any number of arguments to
# write.csv will be passed along
path <- tempfile(fileext = ".csv")
cyphr::encrypt(write.csv(iris, path, row.names = FALSE), key)

# The new file now exists, but you would not be able to read it
# with read.csv because it is now binary data.
file.exists(path)

# Wrap the read.csv call with cyphr::decrypt()
dat <- cyphr::decrypt(read.csv(path, stringsAsFactors = FALSE), key)
head(dat)

file.remove(path)

# If you have a function that is not supported you can specify the
# filename argument directly.  For example, with "write.dcf" the
# filename argument is called "file"; we can pass that along
path <- tempfile()
cyphr::encrypt(write.dcf(list(a = 1), path), key, file_arg = "file")

# Similarly for decryption:
cyphr::decrypt(read.dcf(path), key, file_arg = "file")
}
