% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data_request_access}
\alias{data_request_access}
\alias{data_key}
\title{User commands}
\usage{
data_request_access(path_data = NULL, path_user = NULL, quiet = FALSE)

data_key(
  path_data = NULL,
  path_user = NULL,
  test = TRUE,
  quiet = FALSE,
  cache = TRUE
)
}
\arguments{
\item{path_data}{Path to the data.  If not given, then we look
recursively down below the working directory for a ".cyphr"
directory, and use that as the data directory.}

\item{path_user}{Path to the directory with your user key.
Usually this can be omitted.  This argument is passed in as both
\code{pub} and \code{key} to \code{\link[=keypair_openssl]{keypair_openssl()}}.
Briefly, if this argument is not given we look at the
environment variables \code{USER_PUBKEY} and \code{USER_KEY} -
if set then these must refer to path of your public and private
keys.  If these environment variables are not set then we fall
back on \verb{~/.ssh/id_rsa.pub} and \verb{~/.ssh/id_rsa},
which should work in most environments.  Alternatively, provide
a path to a directory where the file \code{id_rsa.pub} and
\code{id_rsa} can be found.}

\item{quiet}{Suppress printing of informative messages.}

\item{test}{Test that the encryption is working?  (Recommended)}

\item{cache}{Cache the key within the session.  This will be
useful if you are using ssh keys that have passwords, as if the
key is found within the cache, then you will not have to
re-enter your password.  Using \code{cache = FALSE} neither
looks for the key in the cache, nor saves it.}
}
\description{
User commands
}
\examples{

# The workflow here does not really lend itself to an example,
# please see the vignette.

# Suppose that Alice has created a data directory:
path_alice <- tempfile()
cyphr::ssh_keygen(path_alice, password = FALSE)
path_data <- tempfile()
dir.create(path_data, FALSE, TRUE)
cyphr::data_admin_init(path_data, path_user = path_alice)

# If Bob can also write to the data directory (e.g., it is a
# shared git repo, on a shared drive, etc), then he can request
# access
path_bob <- tempfile()
cyphr::ssh_keygen(path_bob, password = FALSE)
hash <- cyphr::data_request_access(path_data, path_user = path_bob)

# Alice can authorise Bob
cyphr::data_admin_authorise(path_data, path_user = path_alice, yes = TRUE)

# After which Bob can get the data key
cyphr::data_key(path_data, path_user = path_bob)

# See the vignette for more details.  This is not the best medium
# to explore this.

# Cleanup
unlink(path_alice, recursive = TRUE)
unlink(path_bob, recursive = TRUE)
unlink(path_data, recursive = TRUE)
}
