% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_permutation_matrices.R
\name{vec_permutation_matrices}
\alias{vec_permutation_matrices}
\title{Generate templates for dispersal, demography, and permutation matrices}
\usage{
vec_permutation_matrices(num.sp, num.sites, num.stages)
}
\arguments{
\item{num.sp}{integer, number of species}

\item{num.sites}{integer, number of sites}

\item{num.stages}{integer, number of stages}
}
\value{
nested list, of the form `list[[type]][[sp]]`, where `type` is 
demography, dispersal, or permutation.
}
\description{
this follows the vec-permutation approach
as defined in: 
Hunter and Caswell 2005, doi:10.1016/j.ecolmodel.2005.05.002, 
Ozgul et al. 2009, doi: 10.1086/597225
}
\examples{
# number of demographic stages - this should be always fixed to 3 for 
# compatibility with other functions
num.stages <- 3
num.sp <- 4
num.sites <- 5
vpm <- vec_permutation_matrices(num.sp,num.sites,num.stages)
}
