% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_vital_rate_coefs.R
\name{generate_vital_rate_coefs}
\alias{generate_vital_rate_coefs}
\title{Generate coefficients for obtaining vital rates}
\usage{
generate_vital_rate_coefs(
  param,
  sp = NULL,
  sites = NULL,
  vital.rate = NULL,
  vr.coef = NULL,
  mean.coef = NULL,
  sd.coef = NULL,
  glm.object = NULL,
  glm.coef.equivalence = NULL
)
}
\arguments{
\item{param}{the original list with the structure of species, sites, 
vital rates to calculate, and parameters affecting them. See the function `build_param`}

\item{sp}{number or character of the species to calculate coefficients for. If empty, all species are assumed.}

\item{sites}{number or character of the sites to calculate coefficients for. If empty, all sites are assumed.}

\item{vital.rate}{character giving the vital rate to calculate coefficients for. If empty, all vital rates are assumed.}

\item{vr.coef}{character giving a specific coefficient to calculate. If empty, all coefficients are assumed.}

\item{mean.coef}{optional numeric value, mean for sampling coefficient values}

\item{sd.coef}{optional numeric value, standard deviation for sampling coefficient values}

\item{glm.object}{optional model object/coef table}

\item{glm.coef.equivalence}{if a glm table is provided and its names differ from the `param` data structure, 
you can include a named list in which names are the names from `param` and its elements are the equivalent names from the glm table}
}
\value{
the updated parameter list
}
\description{
Any vital rate is a function of several parameters, potentially including
interactions or environmental effects. This function generates the coefficients
for these parameters, so that users do not have to introduce them all manually
in a `param` list. Coefficients can be generated from a random sampling of
a normal distribution with specified mean and standard deviation, 
or they can be retrieved from a model object that accepts a `tidy` function
from the broom/broom.mixed packages. This is because coefficients for 
vital rates can be understood as coefficients from statistical regressions.
}
\details{
In the current version, we assume that the model coefficients come from a
logistic regression with binomial family. Otherwise, the function will probably not fail,
but the coefficients will not be interpretable and the results in terms of obtaining the actual
vital rates from these will be meaningless.

Also note that you need to take care manually of the signs of the coefficients,
if entered through mean/sd pairs.
}
