#' Species germination and survival rates
#' 
#' A dataset containing germination and survival rates for 17 plant species. 
#' It includes columns with the scientific names and their associated codes.
#' 
#' \itemize{      
#'   \item species: binomial name
#'   \item code: four-letter code used in other datasets
#'   \item germination: germination rate
#'   \item seed.survival: annual survival of ungerminated seed in the soil
#'   }
#'   
#' @note For details, see Lanuza et al. 2018 Ecology Letters. 
#' @docType data
#' @keywords datasets
#' @name species_rates
#' @usage data(species_rates)
#' @format A data frame with 17 rows and 4 variables
"species_rates"