% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmPval.R
\name{cvmPval}
\alias{cvmPval}
\title{cvmPval}
\usage{
cvmPval(statistic, Msig, imhof = TRUE)
}
\arguments{
\item{statistic}{test statistic}

\item{Msig}{Matrix used to produce eigenvalues to estimate the asymptotic distributions of the test statistic}

\item{imhof}{Logical. Set to be FALSE if Imhof's method is NOT used to approximate the null. The package"CompQuadForm" is required if "imhof=TRUE"}
}
\value{
P-value for test statistic
}
\description{
Calculate P values of CVM statistics using their asymptotic distributions
}
\details{
cvmPval is used by groupFit to calculate test statistics for fit distributions.
}
\examples{

# A_squared and MsigA derived from
#(Choulakian, Lockhart and Stephens(1994) Example 3, p8)

A_squared <- 1.172932

MsigA <- matrix(c(0.05000, 0.03829, 0.02061, 0.00644,
                  0.03829, 0.30000, 0.16153, 0.05050,
                  0.02061, 0.16153, 0.30000, 0.09379,
                  0.00644, 0.05050, 0.09379, 0.30000),
                nrow = 4, ncol = 4, byrow = TRUE)

(U2Pval1 = cvmPval(A_squared, MsigA))

U_squared <- 0

MsigU <- matrix(c(0.16666667, 0.10540926, 0.0745356, 0.05270463, 0.03333333,
                  0.10540926, 0.16666667, 0.1178511, 0.08333333, 0.05270463,
                  0.07453560, 0.11785113, 0.1666667, 0.11785113, 0.07453560,
                  0.05270463, 0.08333333, 0.1178511, 0.16666667, 0.10540926,
                  0.03333333, 0.05270463, 0.0745356, 0.10540926, 0.16666667),
                nrow = 5, ncol = 5, byrow = TRUE)

(U2Pval2 = cvmPval(U_squared, MsigU, imhof = FALSE))

}
\seealso{
\code{\link{groupFit}}: Data fitting function
}
\author{
Shaun Zheng Sun and Dillon Duncan
}
