% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5-Write.R
\name{wrkp}
\alias{wrkp}
\title{Echo Keypress to Screen}
\usage{
wrkp(ignore = "escape", fn = list(), ...)
}
\arguments{
\item{ignore}{vector of keypresses to ignore.}

\item{fn}{list of functions, named by key, to be called when key is pressed.}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Detect keypress and print it to the terminal screen, while invisibly returning the keypress. The user can specify which characters to ignore, and can also map keys to a list of functions. Any keypress mapped to a function will not be echoed to the screen.
}
\examples{
\dontrun{
wrkp(
 ignore="escape",
 fn = list(
   enter = function(){mv_row(1)},
   left = function(){mv(0, -1)},
   right = function(){mv(0, 1)},
   up = function(){mv(-1,0)},
   down = function(){mv(1,0)},
   space = function(){cat(" ")}
 )
)
}

}
\seealso{
Other writing functions: 
\code{\link{wrat}()},
\code{\link{wrch}()},
\code{\link{wrkpl}()},
\code{\link{wr}()}
}
\concept{writing functions}
