% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-Move.R
\name{mv}
\alias{mv}
\title{Move Cursor}
\usage{
mv(row = 0L, col = 0L)
}
\arguments{
\item{row}{number of rows in which to move the cursor. Positive values move the cursor down; negative values move the cursor up. If \code{row} has two or more values, the second value replaces \code{col}.}

\item{col}{number of columns in which to move the cursor. Positive values move the cursor forward; negative values move the cursor backwards.}
}
\value{
\code{NULL}
}
\description{
Move cursor relative to its current position on the screen. Screen coordinates are given by \code{(row, column)} with the position of the screen being \code{(1, 1)}.
}
\details{
The user must be in a terminal to use the functionality; it will not work in RStudio or the R GUI.
}
\examples{
# move the cursor down one and forward two
mv(1, 2)

# Alternatively, you can specify the coordinates as a single vector.
loc <- c(1, 2)
mv(loc)

# to move to the left one unit (only works if the current column is > 1)
mv(, -1)

}
\seealso{
\code{\link{mv_to}} to move to a specific location on the screen.

Other moving functions: 
\code{\link{mv_col}()},
\code{\link{mv_row}()},
\code{\link{mv_to}()}
}
\concept{moving functions}
