% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{hline_at}
\alias{hline_at}
\title{Draw Horizontal Line}
\usage{
hline_at(yx, n, text = "-", ...)
}
\arguments{
\item{yx}{\code{(row, col)} coordinates where line should be drawn.}

\item{n}{integer describing the character length of the line}

\item{text}{character to be repeated}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Draws a horizontal line of length \code{n} at \code{(row, col)}
}
\examples{
hline_at(c(3,4),6,"-") # print "------" at (3,4)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
