% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-BasicTerminal.R
\name{getkp}
\alias{getkp}
\title{Get Keypress}
\usage{
getkp(fn = list(), echo = FALSE)
}
\arguments{
\item{fn}{list of named functions}

\item{echo}{whether the keypress should be echoed to the screen if not found in list}
}
\value{
character naming the key that was pressed \emph{(invisibly)}.
}
\description{
Listen for a keypress, then apply keypress to a function or echo it to the terminal screen. The user must be in a terminal to use \code{getkp}; it will not work in RStudio or the R GUI. All actions within R are halted until the keypress is returned.
}
\examples{
f <- list(
	 'up'    = function(){mv(row=-1)},
  'down'  = function(){mv(row=-1)},
	 'left'  = function(){mv(col=-1)},
	 'right' = function(){mv(col=1)}
)
\dontrun{
getkp(fn=f, echo=FALSE)
}

}
