% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{draw_shape}
\alias{draw_shape}
\title{Draw a Shape}
\usage{
draw_shape(mat, cycle = TRUE, n = 30, text = "x", ...)
}
\arguments{
\item{mat}{an Nx2 matrix of \code{(row, col)} coordinates}

\item{cycle}{logical value determining whether to the first and last coordinates}

\item{n}{number of points along each edge to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path of a shape given supplied vertices and draw to screen.
}
\examples{
# Right Triangle
draw_shape(rbind(
  c(10,1),
  c(10,10),
  c(1,1)
), cycle=TRUE)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
