% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{draw_arc}
\alias{draw_arc}
\title{Draw an Arc}
\usage{
draw_arc(yx, start, end, r = 1, n = 50, text = "x", ...)
}
\arguments{
\item{yx}{center \code{(row, col)} coordinate of circle}

\item{start}{starting angle in radians}

\item{end}{ending angle in radians}

\item{r}{radius of circle}

\item{n}{number of points along curve to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path of an arc within a grid and print to screen.
}
\examples{
draw_arc(yx=c(10,10), start=pi/2, end=pi, r=6)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
