% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionality.R
\name{ssm.compositionality}
\alias{ssm.compositionality}
\alias{ssm.segmentation}
\title{Find a segmentation that maximises the overall string coverage across all signals.}
\usage{
ssm.compositionality(x, y, groups = NULL)

ssm.segmentation(x, y, mergefeatures = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{a list or vector of character sequences}

\item{y}{a matrix or data frame with as many rows as there are
strings (see section Meaning data format)}

\item{groups}{a list or vector with as many items as strings, used to split
the signals and meanings into data sets for which the compositionality
measures are computed separately.}

\item{mergefeatures}{logical: if \code{TRUE}, \code{ssm.segmentation} will
try to improve on the initial solution by incrementally merging pairs of
meaning features as long as doing so improves the overall string coverage
of the segmentation.}

\item{verbose}{logical: if \code{TRUE}, messages detailed information about
the number of segment combinations considered for every coverage computed.}
}
\description{
This algorithm builds on Spike's measure of compositionality (see
\code{\link{sm.compositionality}}), except instead of simply determining
which segment(s) have the highest mutual predictability for each
meaning feature separately, it attempts to find a combination of
non-overlapping segments for each feature that maximises the overall string
coverage over all signals. In other words, it tries to find a segmentation
which can account for (or 'explain') as much of the string material in the
signals as possible.
}
\details{
For large data sets and long strings, this computation can get very slow.
If the attested signals are such that no perfect segmentation is possible,
this algorithm is not guaranteed to find any segmentation (as no such
segmentation might exist).
}
\examples{
ssm.segmentation(c("as", "bas", "basf"),
  cbind(a=c(TRUE, FALSE, TRUE), b=c(FALSE, TRUE, TRUE)))


# signaling system where one meaning distinction is not encoded in the signals
print(threebytwoanimals <- enumerate.meaningcombinations(list(animal=c("dog", "cat", "tiger"),
  colour=c("col1", "col2"))))

ssm.segmentation(c("greendog", "bluedog", "greenfeline", "bluefeline", "greenfeline", "bluefeline"),
  threebytwoanimals)

# the same analysis again, but allow merging of features
ssm.segmentation(c("greendog", "bluedog", "greenfeline", "bluefeline", "greenfeline", "bluefeline"),
  threebytwoanimals, mergefeatures=TRUE)
}
\seealso{
\code{\link{sm.compositionality}}
}
