% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{repmatrix}
\alias{repmatrix}
\title{Extend a matrix by repetition of elements.}
\usage{
repmatrix(x, times = 1, each = 1, times.row = times, times.col = times,
  each.row = each, each.col = each, ...)
}
\arguments{
\item{x}{a matrix}

\item{times}{how often the matrix should be replicated next to itself}

\item{each}{how often individual cells should be replicated next to themselves}

\item{times.row}{number of vertical repetitions of the matrix, overrides \code{times}}

\item{times.col}{number of horizontal repetitions of the matrix, overrides \code{times}}

\item{each.row}{number of vertical repetitions of individual elements, overrides \code{each}}

\item{each.col}{number of horizontal repetitions of individual elements, overrides \code{each}}

\item{...}{not used}
}
\value{
A matrix, which will have \code{times*each} times more rows and
columns than the original matrix.
}
\description{
Returns a new matrix, where the entries of the original matrix are
repeated along both dimensions.
}
\examples{
repmatrix(diag(4))
repmatrix(diag(4), times=2)
repmatrix(diag(4), each=2)
repmatrix(diag(3), times=2, each=2)
repmatrix(diag(4), each.row=2)
repmatrix(diag(4), times.row=2)
}
\seealso{
\code{\link[base]{rep}}
}
