% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{enumerate.meaningcombinations}
\alias{enumerate.meaningcombinations}
\title{Enumerate meaning combinations.}
\usage{
enumerate.meaningcombinations(dimensionality, uniquelabels = TRUE,
  offset = 0)
}
\arguments{
\item{dimensionality}{either a) a vector of integers specifying the number
of different possible values for every meaning dimension, or b) a list or
other (potentially ragged) 2-dimensional data structure listing the
possible meaning values for every dimension}

\item{uniquelabels}{logical, determines whether the same integers can be
reused across meaning dimensions or not. When \code{uniquelabels = FALSE},
the resulting matrix will be very reminiscent of tables listing all binary
combinations of factors. Ignored when \code{dimensionality} specifies the
meaning values}

\item{offset}{a constant that is added to all meaning specifiers. Ignored
when \code{dimensionality} specifies the meaning values}
}
\value{
A matrix that has as many columns as there are dimensions, with
every row specifying one of the possible meaning combinations. The entries
of the first dimension cycle slowest (see examples).
}
\description{
Enumerates all possible combinations of meanings for a meaning space of the
given dimensionality.
}
\details{
The resulting matrix can be passed straight on to
\code{\link{hammingdists}} and other meaning distance functions created by
\code{\link{wrap.meaningdistfunction}}.
}
\examples{
enumerate.meaningcombinations(c(2, 2))
enumerate.meaningcombinations(c(3, 4))
enumerate.meaningcombinations(c(2, 2, 2, 2))
enumerate.meaningcombinations(8) # trivial
enumerate.meaningcombinations(list(shape=c("square", "circle"), color=c("red", "blue")))
}
\seealso{
\code{\link{hammingdists}}
}
