test_that("sliding window function works", {
    x <- slide(1, 10, step = 3)
    expect_equal(x$start, c(1, 4, 7, 10))
    expect_equal(x$center, c(1, 4, 7, 10))
    expect_equal(x$end, c(1, 4, 7, 10))
    x <- slide(1, 10, step = 3, before = 1, after = 2)
    expect_equal(x$start, c(1, 4, 7))
    expect_equal(x$end, c(4, 7, 10))
    x <- slide(1, 11, step = 3, before = 1, after = 2)
    expect_equal(x$start, c(1, 4, 7))
    expect_equal(x$end, c(4, 7, 10))
    x <- slide(1, 12, step = 3, before = 1, after = 2)
    expect_equal(x$start, c(1, 4, 7))
    expect_equal(x$end, c(4, 7, 10))
    x <- slide(1, 13, step = 3, before = 1, after = 2)
    expect_equal(x$start, c(1, 4, 7, 10))
    expect_equal(x$end, c(4, 7, 10, 13))
    expect_error(slide(1, 10, before = 10, after = 10))
    expect_error(slide_codon('AAA', step = 1, before = 10, after = 10))
})
