% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctLOO.R
\name{ctLOO}
\alias{ctLOO}
\title{K fold cross validation for ctStanFit objects}
\usage{
ctLOO(
  fit,
  folds = 10,
  cores = 2,
  parallelFolds = FALSE,
  tol = 1e-05,
  subjectwise = ifelse(length(unique(fit$standata$subject)) >= folds, TRUE, FALSE),
  keepfirstobs = FALSE,
  leaveOutN = NA,
  refit = TRUE,
  casewiseApproximation = FALSE
)
}
\arguments{
\item{fit}{ctStanfit object}

\item{folds}{Number of cross validation splits to use -- 10 folds implies that the 
model is re-fit 10 times, each time to a data set with 1/10 of the observations randomly removed.}

\item{cores}{Number of processor cores to use.}

\item{parallelFolds}{compute folds in parallel or use cores to finish single folds faster. 
parallelFolds will use folds times as much memory.}

\item{tol}{tolerance for optimisation of refitted samples, can generally be more relaxed than the tolerance used for fitting initially.}

\item{subjectwise}{drop random subjects instead of data rows?}

\item{keepfirstobs}{do not drop first observation (more stable estimates)}

\item{leaveOutN}{if a positive integer is given, the folds argument is ignored and 
instead the folds are calculated by leaving out every Nth row from the data when fitting. 
Leaving 2 out would result in 3 folds (starting at rows 1,2,3), each containing one third of the data.}

\item{refit}{if FALSE, do not optimise parameters for the new data set, 
just compute the likelihoods etc from the original parameters}

\item{casewiseApproximation}{if TRUE, use a bootstrapped gradient contributions approach to approximate the cross validation parameters -- much faster but less reliable.}
}
\value{
list
}
\description{
K fold cross validation for ctStanFit objects
}
\examples{
\donttest{ 
ctLOO(ctstantestfit)
}
}
