% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cterTest.R
\name{cterTest}
\alias{cterTest}
\title{test the existence of change point in the continuous threshold expectile regression}
\usage{
cterTest(y, x, z, tau = 0.5, NB = 1000)
}
\arguments{
\item{y}{A vector of response}

\item{x}{A scalar covariate with threshold}

\item{z}{A vector of covariates}

\item{tau}{the expectile level, 0.5 for default}

\item{NB}{resampling times, 1000 for default}
}
\value{
A list with the elements
\item{Tn}{The statistic based on original data.}
\item{Tn.NB}{The statistics by wild bootstrap.}
\item{p.value}{The p-value by wild bootstrap.}
}
\description{
This function for calculating the test statistics and p-value by wild bootstrap.
}
\examples{

## simulated data
ptm <- proc.time()
set.seed(1)
n <- 200
t0 <- 1.5
bet0 <- c(1, 3, 0, 1)
tau <- 0.3
modtype <- 1
errtype <- 1
dat <- cterSimData(n, bet0, t0, tau, modtype, errtype)
y <- dat[, 1]
x <- dat[, 2]
z <- dat[, 3]
fit.test <- cterTest(y, x, z, tau, NB = 30)
fit.test$p.value

## The example of Baseball pitcher salary
data(data_bbsalaries)
y <- data_bbsalaries$y
x <- data_bbsalaries$x
z <- NULL
tau <- 0.5
fit.test <- cterTest(y, x, z, tau, NB = 30)
fit.test$p.value
proc.time() - ptm
}
\author{
Feipeng Zhang and Qunhua Li
}
\keyword{cterTest}

