% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cterSimData.R
\name{cterSimData}
\alias{cterSimData}
\title{Simulated data from the continuous threshold expectile regression}
\usage{
cterSimData(n, bet0, t0, tau = 0.5, modtype = 1, errtype = 1)
}
\arguments{
\item{n}{sample size.}

\item{bet0}{the vecotr of true regression coefficients.}

\item{t0}{the true location of threshold.}

\item{tau}{the expectile level, 0.5 for default.}

\item{modtype}{type of model, 1 = IID for default, 2 = Heteroscedasticity,
modtype = 1, \eqn{Y = beta_0 + beta_1 X + beta_2 (X-t)_+ gamma Z + e,}
modtype = 1, \eqn{Y = beta_0 + beta_1 X + beta_2 (X-t)_+ gamma Z + (1+0.2Z)e,}}

\item{errtype}{type of error, 1 for default,
errtype = 1 for N(0, 1),
errtype = 2 for t_4,
errtype = 3 for 0.9 N(0, 1) + 0.1 t_4.}
}
\value{
A matrix with the elements
\item{y}{The response variable.}
\item{x}{The scalar covariate with threshold.}
\item{z}{A vector of covariates.}
}
\description{
The function for  simulating data from the continuous threshold expectile regression
}
\examples{

## simulated data
ptm <- proc.time()
n <- 200
t0 <- 1.5
bet0 <- c(1, 3, -2, 1)
tau <- 0.5
modtype <- 1
errtype <- 1
dat <- cterSimData(n, bet0, t0, tau, modtype, errtype)
head(dat)
proc.time() - ptm
}
\author{
Feipeng Zhang and Qunhua Li
}
\keyword{cterSimData}

