% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_csvy.R
\name{write_csvy}
\alias{write_csvy}
\title{Export CSVY data}
\usage{
write_csvy(x, file, metadata = NULL, sep = ",", dec = ".",
  comment_header = if (is.null(metadata)) TRUE else FALSE,
  name = deparse(substitute(x)), metadata_only = FALSE, ...)
}
\arguments{
\item{x}{A data.frame.}

\item{file}{A character string or R connection specifying a file.}

\item{metadata}{Optionally, a character string specifying a YAML (\dQuote{.yaml}) or JSON (\dQuote{.json}) file to write the metadata (in lieu of including it in the header of the file).}

\item{sep}{A character string specifying a between-field separator. Passed to \code{\link[data.table]{fwrite}}.}

\item{dec}{A character string specifying a within-field separator. Passed to \code{\link[data.table]{fwrite}}.}

\item{comment_header}{A logical indicating whether to comment the lines containing the YAML front matter. Default is \code{TRUE}.}

\item{name}{A character string specifying a name for the dataset.}

\item{metadata_only}{A logical indicating whether only the metadata should be produced (no CSV component).}

\item{\dots}{Additional arguments passed to \code{\link[data.table]{fwrite}}.}
}
\description{
Export data.frame to CSVY
}
\examples{
library("datasets")
write_csvy(head(iris))

# write yaml w/o comment charaters
write_csvy(head(iris), comment_header = FALSE)

}
\seealso{
\code{\link{write_csvy}}
}
