% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nor_locations_names.R
\name{nor_locations_names}
\alias{nor_locations_names}
\title{All names in Norway}
\source{
\url{https://no.wikipedia.org/wiki/Liste_over_norske_kommunenummer}
}
\usage{
nor_locations_names(border = csdata::config$border_nor)
}
\arguments{
\item{border}{The year in which Norwegian geographical boundaries were designated (2020, 2024).}
}
\value{
\describe{
\item{location_code}{Location code.}
\item{location_name}{Location name.}
\item{location_name_short}{3 letter location name for nation and county. A shorter location name for wardoslo and extrawardoslo. }
\item{location_name_description_nb}{Location name with additional description.}
\item{location_name_file_nb_utf}{Location name that should be used in file names, with Norwegian characters.}
\item{location_name_file_nb_ascii}{Location name that should be used in file names, without Norwegian characters.}
\item{location_order}{The preferred presentation order.}
\item{granularity_geo}{nation, county, municip, wardoslo, wardbergen, wardstavanger, wardtrondheim, baregion, lab.}
}
}
\description{
All names in Norway
}
\examples{
nor_locations_names()
}
