% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{prepareDataForCrunch}
\alias{prepareDataForCrunch}
\title{Translate a data.frame to Crunch format}
\usage{
prepareDataForCrunch(data, ..., project = defaultCrunchProject())
}
\arguments{
\item{data}{A \code{data.frame} or other rectangular R object}

\item{...}{additional arguments passed to \link{createDataset}.
"name" will be required by the Crunch server but is not required by this
function.}

\item{project}{A \code{ProjectFolder} object, string path that could be passed to \code{\link[=cd]{cd()}}
relative to the root project, or a URL for a \code{ProjectFolder}. If left empty,
rcrunch will look in \code{envOrOption('crunch.default.project')} and error if nothing
is found.}
}
\value{
A data.frame that is a transformation of \code{data} suitable for
uploading to Crunch, also containing a "metadata" attribute that is
the associated Crunch metadata.
}
\description{
This is called within \code{newDataset} to extract the Crunch metadata
from the data and to transform the data to match the extracted metadata. You
can call this directly in order to tailor the data import flow more finely.
}
\seealso{
createWithPreparedData writePreparedData
}
