% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_crs.R
\name{guess_crs}
\alias{guess_crs}
\title{Guess the CRS of a dataset that is missing CRS information}
\usage{
guess_crs(input, target_location, units = NULL, n_return = 10, input_sf = NULL)
}
\arguments{
\item{input}{A spatial dataset of class \code{"sf"}, \code{"Spatial*"},
\code{"RasterLayer"}, \code{"SpatVector"}, or \code{"SpatRaster"}
in a projected coordinate reference system that is
missing CRS information. For example, you may have loaded in a shapefile without
a .prj file, or your input data has no CRS definition attached.}

\item{target_location}{A coordinate pair of form \code{c(longitude, latitude)}
or an address/location that you know is located within your
input sf object.  If the mapboxapi package is installed, you can
supply a location name (e.g. an address or a city) instead of a
coordinate pair.}

\item{units}{If known, the units of your projected coordinate system (e.g. \code{"m"} for
meters or \code{"us-ft"} for US feet).  This is not required but will make
the guesses more accurate.}

\item{n_return}{The number of possible CRS choices to return; defaults to 10. A higher
number than that may include CRS options that are unlikely to work with
your data. Use the returned \code{dist_km} column to judge whether the CRS
guess makes sense for your data.}

\item{input_sf}{Deprecated; use \code{input} instead.}
}
\value{
A tibble of CRS guesses for your data, sorted in ascending order of distance between
        your target location and the input sf object's centroid when in that CRS.
}
\description{
This function will "guess" possible coordinate reference systems for spatial data that are
lacking a CRS definition.  Input data, which must be of class \code{"sf"}
(or which can be converted to sf) might be objects
created from CSV files that use projected coordinates or objects created from shapefiles
loaded with \code{sf::st_read()} that are missing .prj files.  The function requires a
"target location" that the user knows to be within the general area of the input dataset.  It
then identifies suitable coordinate reference systems for that area and "tests out"
those CRSs for the input data by analyzing the distance between the dataset and the known location
when that CRS is used.  Those distances are returned by the function in a column \code{dist_km};
short distances represent better guesses for the CRS whereas longer distances suggest that
the CRS wouldn't work.
}
\examples{
\dontrun{
library(crsuggest)
library(sf)
# An example data frame of projected coordinates with no CRS information included
locations <- data.frame(
  X = c(2312654.74514528, 2357493.02092003, 2398978.30047505, 2344378.47525209,
        2475776.26735713, 2493751.94421798, 2456797.1698781, 2448392.13089886,
        2319704.35367616, 2350119.25250331, 2449088.54659236, 2423774.3668849),
  Y = c(6966055.04531077, 6994256.06222144, 6951975.79788762, 6902972.35980149,
        6918178.81070276, 6977643.56941746, 7053989.26343385, 7024543.36487243,
        7015476.52061313, 6953350.28550116, 6945011.24615857, 6912284.16691977),
  id = 1:12
)

# Create an sf object but the CRS is not known
locations_sf <- st_as_sf(locations, coords = c("X", "Y"))

# Use `guess_crs()` to guess the CRS used for the coordinates along with a known coordinate
# in the area of interest
guesses <- guess_crs(locations_sf, target_location = c(-97.1071, 32.7356))
# Set the CRS of your data with the "best guess"
st_crs(locations_sf) <- 6584
}
}
