% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np_pipeline.R
\name{compute_dnp}
\alias{compute_dnp}
\title{main function to compute delta np for every gene in a given dataframe - assumes compute_np has already been run for a given dataset}
\usage{
compute_dnp(
  cache = NULL,
  df,
  experiment_name,
  ppi,
  ncores = 1,
  min_score = NULL
)
}
\arguments{
\item{cache}{user-provided filepath for where to store data etc}

\item{df}{dataframe output of \link{compute_np}}

\item{experiment_name}{name of the experiment for saving output.}

\item{ppi}{should we use biogrid or stringdb for the PPI}

\item{ncores}{number of cores to use for calculations}

\item{min_score}{if ppi is stringdb, which mininum score should we use to filter edges?}
}
\value{
data.frame
}
\description{
This function takes a tidy dataframe as input containing RNA sequencing data for one or more samples and conducts in-silico repression.
Make sure to run with the same arguments for ppi and cache to maintain consistency for a given pipeline.
}
