% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.r
\name{cumsumm}
\alias{cumsumm}
\title{Row-wise Cumulative Sums}
\usage{
cumsumm(mtrx)
}
\arguments{
\item{mtrx}{mpfr two-dimensional array.}
}
\value{
mpfr array with row-wise cumulative sums,
same dimension as the original array.
}
\description{
Row-wise Cumulative Sums in mpfr Array.
}
\examples{
nill <- Rmpfr::mpfr(0, 120)
one <- Rmpfr::mpfr(1, 120)
two <- Rmpfr::mpfr(2, 120)
contents <- c(one,nill,nill, one,one,one, two,two,two)
mtrx3 <- Rmpfr::mpfr2array(contents, dim = c(3, 3))
print(mtrx3)
print(cumsumm(mtrx3))
}
