% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_x}
\alias{write_x}
\title{Write atomic coordinates to a file.}
\usage{
write_x(filename, sdata)
}
\arguments{
\item{filename}{A character string. Prefix of the output ASCII file to
include all structural information. The file name will be "[Prefix]_x.dat".}

\item{sdata}{A named list, normally obtained through the use of
function \code{\link{read_x}}. The list names correspond to 
different object types:
\itemize{
  \item{a.     Real numeric. The size of the unit cell.}
  \item{SG.    Character string. Space group symbol; either "P1" 
               or "P-1"}
  \item{x0.    Vector of real numerics indicating the expanded atomic
               positions in the unit cell.}
  \item{Z.     Vector of integers indicating the expanded 
               atomic numbers for all atoms in the unit cell.}
  \item{B.    Vector of real numerics indicating the expanded 
              B factors for all atoms in the unit cell.}
  \item{occ.  Vector of real numerics indicating the expanded 
              occupancies for all atoms in the unit cell.}
}}
}
\value{
This function does not return anything, but will create an ASCII 
 file of name *_x.dat which contains all coordinates of the atoms in the 
 structure and other type of information.
}
\description{
Function to export all information concerning a given structure to a
so-called coordinates file of type *_x.dat.
}
\examples{
# Create an arbitrary structure in P1
a <- 23
SG <- "P1"
x0 <- c(2,11,16,19)
Z <- c(6,6,16,8)
B <- c(13,14,5,10)
occ <- c(1,1,1,1)
wd <- tempdir()
prfx <- file.path(wd,"test")
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)
write_x(prfx,sdata)

}
