% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_space.R
\name{reduce_to_asu}
\alias{reduce_to_asu}
\title{Reduce content of unit cell to asymmetric unit.}
\usage{
reduce_to_asu(adata, SG = NULL)
}
\arguments{
\item{adata}{A named list, normally obtained through the use of
function \code{\link{read_x}}. The list names correspond to 
different object types:
\itemize{
  \item{a.     Real numeric. The size of the unit cell.}
  \item{SG.    Character string. Space group symbol; either "P1" 
               or "P-1"}
  \item{x0.    Vector of real numerics indicating the expanded atomic
               positions in the unit cell.}
  \item{Z.     Vector of integers indicating the expanded 
               atomic numbers for all atoms in the unit cell.}
  \item{B.    Vector of real numerics indicating the expanded 
              B factors for all atoms in the unit cell.}
  \item{occ.  Vector of real numerics indicating the expanded 
              occupancies for all atoms in the unit cell.}
}}

\item{SG}{2-letters character string. There are only two symmetries
possible when working within 1D crystallography, P1 (no symmetry)
and P-1 (inversion through the origin). SG can be either "P1" or
"P-1" for this function. Default is NULL, in which case the space
group is assumed to be equal to the one of the input structure.}
}
\value{
A named list with the following elements:
 \itemize{
   \item{x0. Vector of real numerics indicating the reduced atomic
               positions in the asymmetric unit.}
   \item{Z.  Vector of integers indicating the reduced atomic numbers
               for all atoms in the asymmetric unit.}
   \item{B.  Vector of real numerics indicating the reduced B factors
               for all atoms in the asymmetric unit.}
   \item{occ. Vector of real numerics indicating the reduced occupancies
                 for all atoms in the asymmetric unit.}
 }
}
\description{
Atom types, B factors and occupancies are restricted to those corresponding
to positions in the asymmetric unit, if the input space group (SG) is P-1.
Otherwise they are only sorted according to increasing atom positions. If
the starting positions do not correspond to a properly symmetry-expanded
set, then a warning is issued. If no symmetry is used (P1) the starting set
is forced to have values inside the unit cell and it is sorted according
to increasing atom positions.
}
\examples{
# Asymmetric unit includes 4 atoms between 0 and a/2, 1 in special position
a <- 10
SG <- "P-1"
x0 <- c(1,2,4,5)
Z <- c(6,8,6,16)
B <- c(1,1.2,1.1,0.8)
occ <- c(1,1,1,0.5)
adata <- standardise_sdata(a,SG,x0,Z,B,occ)
ltmp <- expand_to_cell(adata)
print(ltmp)  # Positions, atomic numbers, etc. have doubled

# Now these expanded values are used as input for reduction
ltmp2 <- reduce_to_asu(ltmp)

# Compare
print(x0)
print(ltmp2$x0)

# SG is "P1"
a <- 16
SG <- "P1"
x0 <- c(1,2,7,9,12,16)
Z <- c(6,6,8,8,7,6)
B <- c(0,0,0,0,0,0)
occ <- c(1,1,1,1,1,1)
adata <- standardise_sdata(a,SG,x0,Z,B,occ)
ltmp3 <- reduce_to_asu(adata)
print(ltmp3) # Now all positions are inside the unit cell
}
