% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{RuleDesign-class}
\alias{RuleDesign-class}
\alias{.RuleDesign}
\alias{RuleDesign}
\alias{.DefaultRuleDesign}
\alias{ThreePlusThreeDesign}
\title{\code{RuleDesign}}
\usage{
RuleDesign(nextBest, cohort_size, data, startingDose)

.DefaultRuleDesign()

ThreePlusThreeDesign(doseGrid)
}
\arguments{
\item{nextBest}{(\code{NextBest})\cr see slot definition.}

\item{cohort_size}{(\code{CohortSize})\cr see slot definition.}

\item{data}{(\code{Data})\cr see slot definition.}

\item{startingDose}{(\code{number})\cr see slot definition.}

\item{doseGrid}{(\code{numeric})\cr the dose grid to be used (sorted).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{RuleDesign}} is the class for rule-based designs. The difference between
this class and the \code{\link{Design}} class is that \code{\link{RuleDesign}} does not contain
\code{model}, \code{stopping} and \code{increments} slots.
}
\section{Functions}{
\itemize{
\item \code{ThreePlusThreeDesign()}: creates a new 3+3 design object from a dose grid.

}}
\section{Slots}{

\describe{
\item{\code{nextBest}}{(\code{NextBest})\cr how to find the next best dose.}

\item{\code{cohort_size}}{(\code{CohortSize})\cr rules for the cohort sizes.}

\item{\code{data}}{(\code{Data})\cr specifies dose grid, any previous data, etc.}

\item{\code{startingDose}}{(\code{number})\cr the starting dose, it must lie on the dose
grid in \code{data}.}
}}

\note{
Typically, end users will not use the \code{.DefaultRuleDesign()} function.
}
\examples{
# Specify the design to run simulations. The design comprises a model,
# the escalation rule, starting data, a cohort size and a starting dose.

# Initialing a 3+3 design with constant cohort size of 3 and starting dose equal 5.
my_design <- RuleDesign(
  nextBest = NextBestThreePlusThree(),
  cohort_size = CohortSizeConst(size = 3L),
  data = Data(doseGrid = c(5, 10, 15, 25, 35, 50, 80)),
  startingDose = 5
)
# Initialing a 3+3 design with constant cohort size of 3 and starting dose equal 8.
my_design <- ThreePlusThreeDesign(doseGrid = c(8, 10, 15, 25, 35, 50, 80))
}
