% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_non_critical_activities}
\alias{sch_non_critical_activities}
\title{Non Critical Activities}
\usage{
sch_non_critical_activities(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A tibble with non critical activities.
}
\description{
Return a tibble with all non critical activities of a schedule
in an insertion order.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Fictitious Project Example") \%>\%
  sch_reference("VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18") \%>\%
  sch_add_activity(  1L, "a1" , 0L, 2,3,4) \%>\%
  sch_add_activity(  2L, "a2" , 4L, 5) \%>\%
  sch_add_activity(  3L, "a3" , 9L, 10) \%>\%
  sch_add_activity(  4L, "a4" , 1L, 6) \%>\%
  sch_add_activity(  5L, "a5" , 4L, 9) \%>\%
  sch_add_activity(  6L, "a6" , 5L, 7) \%>\%
  sch_add_activity(  7L, "a7" , 1L, 8,11) \%>\%
  sch_add_activity(  8L, "a8" , 7L, 12) \%>\%
  sch_add_activity(  9L, "a9" , 8L, 12) \%>\%
  sch_add_activity( 10L, "a10", 3L, 12) \%>\%
  sch_add_activity( 11L, "a11", 3L, 12) \%>\%
  sch_add_activity( 12L, "a12", 0L) \%>\%
  sch_plan()
sch_non_critical_activities(sch)

}
\seealso{
\code{\link[=sch_get_activity]{sch_get_activity()}}, \code{\link[=sch_add_activity]{sch_add_activity()}}, \code{\link[=sch_activities]{sch_activities()}},
\code{\link[=sch_critical_activities]{sch_critical_activities()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}}, \code{\link[=sch_nr_activities]{sch_nr_activities()}},
\code{\link[=sch_add_activities]{sch_add_activities()}}.
}
