% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{UScrime_df}
\alias{UScrime_df}
\title{The Effect of Punishment Regimes on Crime Rates}
\format{
A data frame with 47 observations and 16 variables:
\describe{
  \item{M}{Number of males aged 14–24 per 100,000 (integer).}
  \item{So}{Indicator for Southern states (1 = South, 0 = non-South) (integer).}
  \item{Ed}{Mean years of schooling (integer).}
  \item{Po1}{Police expenditure in 1960 per capita (integer).}
  \item{Po2}{Police expenditure in 1959 per capita (integer).}
  \item{LF}{Labor force participation rate per 100,000 (integer).}
  \item{M.F}{Ratio of males to females (integer).}
  \item{Pop}{Population size per 100,000 (integer).}
  \item{NW}{Percent non-white population (integer).}
  \item{U1}{Unemployment rate of urban males aged 14–24 (integer).}
  \item{U2}{Unemployment rate of urban males aged 35–39 (integer).}
  \item{GDP}{Gross domestic product per capita (integer).}
  \item{Ineq}{Income inequality indicator (integer).}
  \item{Prob}{Probability of imprisonment (numeric).}
  \item{Time}{Average time served in state prisons (in months) (numeric).}
  \item{y}{Crime rate: number of offenses per 100,000 population (integer).}
}
}
\source{
Aggregate data on crime and punishment regimes in the USA, 1960.
}
\usage{
data(UScrime_df)
}
\description{
This dataset contains aggregate data on crime rates and socioeconomic indicators for 47 states in the USA for 1960.
It explores the effect of punishment regimes on crime rates, with variables scaled to convenient numbers.
}
\details{
The dataset name has been changed to 'UScrime_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'df'
indicates that the dataset is a traditional data frame in R. The original content has not been modified in any way.
}
