% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creditr-package.R
\docType{package}
\name{creditr}
\alias{creditr-package}
\alias{creditr}
\title{The creditr package.}
\description{
\code{creditr} package prices credit default swaps
(CDS). It enables CDS class object which has slots as name, contract, RED, 
date, spread, maturity, teno, coupon, recovery, currency, notional, 
principal, accrual, pd, price, upfront, spread.DV01, IR.DV01 and rec.risk.01,
with S4 methods like update, show and summary. It also supports data frame 
input and is able to provide convenient calculation of key CDS statistics 
through functions like \code{CS10}, \code{IR.DV01}, \code{rec_risk_01} and 
\code{spread_DV01}. Of other major functions, \code{spread_to_upfront} and 
\code{upfront_to_spread} are designed to compute one of spread and upfront 
given the other; \code{spread_to_pd} and \code{pd_to_spread}, similarly, can 
calculate one of spread and probability of default given the other; 
\code{add_dates} and \code{add_conventions} compute a series of dates 
information and accounting conventions related to CDS pricing. Finally, 
\code{get_rates} and \code{build_rates} facilitates direct fetching of 
relevant interest rates from online sources. Thanks to ISDA Standard Model's 
Open Source license, we are able to create this package for R users. You can 
find the Open Source licence of ISDA Standard Model at 
"https://www.cdsmodel.com/cdsmodel/cds-disclaimer.html"
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yanrong-stacy-song/creditr}
}

}
\author{
\strong{Maintainer}: Yanrong Song \email{yrsong129@gmail.com}

Authors:
\itemize{
  \item Zijie Zhu \email{zijie.miller.zhu@gmail.com}
  \item David Kane \email{dave.kane@gmail.com}
  \item Heidi Chen \email{s.heidi.chen@gmail.com}
  \item Yuanchu Dang \email{yuanchu.dang@gmail.com}
  \item Yang Lu \email{yang.lu2014@gmail.com}
  \item Kanishka Malik \email{kanishkamalik@gmail.com}
  \item Skylar Smith \email{sws2@williams.edu}
}

Other contributors:
\itemize{
  \item International Swaps and Derivatives Association (Copyright holder of the free CDS standard model code used in this package) [copyright holder]
}

}
