% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranlogs.R
\name{cran_downloads}
\alias{cran_downloads}
\title{Daily package downloads from the RStudio CRAN mirror}
\usage{
cran_downloads(packages = NULL, when = c("last-day", "last-week",
  "last-month"), from = "last-day", to = "last-day")
}
\arguments{
\item{packages}{A character vector, the packages to query,
or \code{NULL} for a sum of downloads for all packages.
Alternatively, it can also be \code{"R"}, to query downloads
of R itself. \code{"R"} cannot be mixed with packages.}

\item{when}{\code{last-day}, \code{last-week} or \code{last-month} (see 
details). If this is given, then \code{from} and \code{to} are ignored.}

\item{from}{Start date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}

\item{to}{End date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}
}
\value{
For packages a data frame with columns:
  \item{\code{package}}{The package. This column is missing if
    all packages were queried.}
  \item{\code{date}}{Day of the downloads, it is a Date object.}
  \item{\code{count}}{Download count.}

  For downloads of R, there are also columns for the operating
  system (\code{os}) and the R version (\code{version}).
}
\description{
Daily package downloads from the RStudio CRAN mirror
}
\details{
\code{last-day} is the last day for which data is available,
 \code{last-week} is from 6 days prior to that last day with data, 
 \code{last-month} is from 29 days prior to that last day with data.
 
 0 counts can be due to the non-availability of data on the RStudio server 
 for that day.
}
\examples{
\dontrun{
## Default is last day for which data is available.
cran_downloads()

## All downloads for 'dplyr' in the last day for which data is available.
cran_downloads(packages = "dplyr")

## Daily downloads for 'igraph' last week
## (6 days prior to the last day for which data is available)
cran_downloads(packages = "igraph", when = "last-week")

## Downloads in the specified time interval
cran_downloads(from = "2014-06-30", to = "2014-08-08")

## Multiple packages
cran_downloads(packages = c("ggplot2", "plyr", "dplyr"))

## R downloads
cran_downloads("R")
}
}
\seealso{
Other CRAN downloads: \code{\link{cran_top_downloads}}
}
\concept{CRAN downloads}
