% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprobit.R
\name{cprobit}
\alias{cprobit}
\alias{summary.cprobit}
\alias{print.cprobit}
\title{Apply the three-step workflow for the analysis of two repeated outcomes from
each subject}
\usage{
cprobit(
  formula,
  dat,
  index,
  transform = NULL,
  lambda = NA,
  resid_pval_threshold = 0.05
)

\method{summary}{cprobit}(object, plot = FALSE, ...)

\method{print}{cprobit}(x, ...)
}
\arguments{
\item{formula}{Formula for the model. Do not convert data type within the
formula (e.g., \code{factor(x)} is not supported in \code{formula}). See
\code{Details}.}

\item{dat}{A \code{data.frame} in the long format, with each row
corresponding to one measurement from one subject, and two columns
indicating the subject and case ID respecitively. Variable names must not
contain space or special characters.}

\item{index}{Names of variables indicating subject and case ID. Case ID must
be coded as integers 1 and 2.}

\item{transform}{Whether a Box-Cox transformation should be applied to the
outcome, taking value \code{NULL} (the default), \code{TRUE} or
\code{FALSE}.}

\item{lambda}{Value of the Box-Cox transformation parameter to use. Default
is \code{NA}, in which case it will be estimated from data.}

\item{resid_pval_threshold}{The threshold for the Lilliefors p-value of the
residuals to determine whether a Box-Cox transformation on the outcome is
necessary. Default is 0.05.}

\item{object}{Model fitted using \code{cprobit} function.}

\item{plot}{Wether residual qq-plots should be plotted. Default is \code{FALSE}.}

\item{...}{Additional arguments affecting the summary produced (not yet
implemented).}

\item{x}{Model fitted using \code{cprobit} function.}
}
\value{
Returns a list.
}
\description{
Apply the three-step workflow for the analysis of two repeated outcomes from
each subject
}
\details{
Specify the formula for the repeated measurements instead of the
  change in the outcome, but without any time-invariant component that would
  have been eliminated after taking the difference. Interaction between two
  variables can be specified in the formula using \code{*} or \code{:}, but
  users need to create their own variable for interaction involving three or
  more variables.

If \code{transform = NULL}, the workflow will determine the need for a
Box-Cox transforamtion on the outcome (i.e., Step 3) based on the residual
diagnostics in Step 2. A Box-Cox transforamtion will be used if the p-value
of the Lilliefors test is smaller than \code{resid_pval_threshold} (default
is 0.05). If \code{transform = TRUE}, analyses will always be performed on
both the observed and Box-Cox transformed outcomes. If \code{transform =
FALSE}, analysis will only be performed on the observed outcomes.
}
\examples{
# Apply the three-step workflow to assess the association between the
# baseline glucose variability and the change in the glucose variability in
# the subsequent two days.
# Although age and gender are available, they do not need to be explicitly
# adjusted for in the cprobit model.
data(bg_variability)
head(bg_variability)
model <- cprobit(formula = y ~ t + t:sd0, dat = bg_variability,
                 index = c("subject_id", "case_id"))
summary(model, plot = TRUE)
}
\references{
\itemize{
 \item{GEP Box, DR Cox. An Analysis of Transformations. Journal of the Royal
 Statistical Society. Series B (Methodological). 1964;26:211–52.}
 \item{DM Hawkins, S Weisberg. Combining the box-cox power and generalised
 log transformations to accommodate nonpositive responses in linear and
 mixed-effects linear models. South African Stat J. 2017;51:317–28.}
 \item{HW Lilliefors. On the Kolmogorov-Smirnov Test for Normality with Mean
 and Variance Unknown. J Am Stat Assoc. 1967;62:399.}
 \item{Y Ning, NC Støer, PJ Ho, SL Kao, KY Ngiam, EYH Khoo, SC Lee, ES Tai, M
 Hartman, M Reilly, CS Tan. Robust estimation of the effect of an exposure on
 the change in a continuous outcome. BMC Medical Research Methodology
 (in press).}
}
}
