library(cpr)

xvec <- runif(n = 500, min = 0, max = 6)
bmat1 <- bsplines(x = xvec, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta1 <- c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5)
cp1 <- cp(bmat1, theta1)

x <- c(0.2, 0.8, 1.3, 1.73, 2.15, 3.14, 4.22, 4.88, 5.3, 5.9)

stopifnot(
  isTRUE(
    all.equal(
      cp_value(cp1, x = x)
      ,
      c(0.4, 3.26666666666667, 3.92608695652174, 4.135, 3.925, 1.432, -0.600540540540541, -0.510999999999999, 1.19, 1.6)
    )
  )
)


bmat2 <- bsplines(x = xvec, bknots = c(0, 6))
theta2 <- c(1, 3.4, -2, 1.7)
cp2 <- cp(bmat2, theta2)

stopifnot(
  isTRUE(
    all.equal(
      cp_diff(cp1, cp2)
      ,
      c(0, 1.4, -1.5, -1.28, -1.92, -0.42, 0.241666666666666, -1.225, 0.2)
    )
  )
)

################################################################################
#                                 End of File                                  #
################################################################################
