% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_of_iknots.R
\name{influence_of_iknots}
\alias{influence_of_iknots}
\alias{influence_of_iknots.cpr_cn}
\title{Determine the influence of the internal knots of a control polygon}
\usage{
influence_of_iknots(x, verbose = FALSE, ...)

\method{influence_of_iknots}{cpr_cn}(
  x,
  verbose = FALSE,
  margin = seq_along(x$bspline_list),
  n_polycoef = 20L,
  ...
)
}
\arguments{
\item{x}{\code{cpr_cp} or \code{cpr_cn} object}

\item{verbose}{print status messages}

\item{...}{pass through}

\item{margin}{which margin(s) to consider the influence of iknots}

\item{n_polycoef}{number of polynomial coefficients to use when assessing the
influence of a iknot}
}
\value{
a \code{cpr_influence_of_iknots} object.  A list of six elements:
\describe{
\item{original_cp}{}
\item{coarsened_cps}{}
\item{restored_cps}{}
\item{d}{}
\item{influence}{}
\item{chisq}{}
}
}
\description{
Determine the influence of the internal knots of a control polygon
}
\examples{
x <- seq(0 + 1/5000, 6 - 1/5000, length.out = 5000)
bmat <- bsplines(x, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta <- matrix(c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5), ncol = 1)
cp0 <- cp(bmat, theta)

icp0 <- influence_of_iknots(cp0)

plot(cp0, icp0$coarsened_cps[[1]], icp0$restored_cps[[1]], color = TRUE, show_spline = TRUE)
plot(cp0, icp0$restored_cps[[1]], color = TRUE, show_spline = TRUE)

plot(cp0, icp0$coarsened_cps[[2]], icp0$restored_cps[[2]], color = TRUE, show_spline = TRUE)
plot(cp0, icp0$restored_cps[[2]], color = TRUE, show_spline = TRUE)

plot(cp0, icp0$coarsened_cps[[3]], icp0$restored_cps[[3]], color = TRUE, show_spline = TRUE)
plot(cp0, icp0$restored_cps[[3]], color = TRUE, show_spline = TRUE)

plot(cp0, icp0$coarsened_cps[[4]], icp0$restored_cps[[4]], color = TRUE, show_spline = TRUE)
plot(cp0, icp0$restored_cps[[4]], color = TRUE, show_spline = TRUE)

plot(cp0, icp0$coarsened_cps[[5]], icp0$restored_cps[[5]], color = TRUE, show_spline = TRUE)
plot(cp0, icp0$restored_cps[[5]], color = TRUE, show_spline = TRUE)

# When the cp was defined by regression
df <- data.frame(x = x, y = as.numeric(bmat \%*\% theta) + rnorm(5000, sd = 0.2))
cp1 <- cp(y ~ bsplines(x, iknots = c(1, 1.5, 2.3, 3, 4, 4.5), bknots = c(0, 6)), data = df)
icp1 <- influence_of_iknots(cp1)
icp1

}
