% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results}
\alias{results}
\title{Create a results table from a cpam object}
\usage{
results(
  cpo,
  p_threshold = 0.05,
  p_type = c("p_gam", "p_mvn"),
  min_lfc = 0,
  min_count = 0,
  aggregate_to_gene = cpo$aggregate_to_gene,
  add_lfc = TRUE,
  add_counts = TRUE,
  cp_type = c("cp_1se", "cp_min"),
  shape_type = c("shape1", "shape2"),
  summarise_to_gene = FALSE,
  remove_null_targets = TRUE
)
}
\arguments{
\item{cpo}{a cpam object}

\item{p_threshold}{numerical; threshold for adjusted p-values; default is 0.05}

\item{p_type}{character; choose the type of p-value. Options are "p_gam" (default)
or "p_mvn" (see \code{\link[=compute_p_values]{compute_p_values()}} for details).}

\item{min_lfc}{numerical; maximum absolute log (base 2) fold change must
exceed this minimum value; default is 0}

\item{min_count}{numerical; maximum of the modelled counts evaluated at
the set of observed time points must exceed this minimum value for}

\item{aggregate_to_gene}{logical; filter by gene-aggregated p-values}

\item{add_lfc}{logical; add log (base 2) fold changes for each time point}

\item{add_counts}{logical; add modelled counts for each time point}

\item{cp_type}{character; model-selection rule used to select the changepoint}

\item{shape_type}{character; "shape1" to include unconstrained or otherwise "shape2"}

\item{summarise_to_gene}{logical; return gene-level results only}

\item{remove_null_targets}{logical; remove targets with null shapes (default is T).
If F, targets with null shapes will be included if the aggregated p-value for
the corresponding gene passes the specified filtering thresholds.}
}
\value{
a tibble
}
\description{
Create a results table from a cpam object
}
\details{
This function is usually called after
\code{\link[=compute_p_values]{compute_p_values()}}, \code{\link{estimate_changepoint}}, and \code{select_shape} have
been run. The function has several useful filters such as adjusted p-value
thresholds, minimum log-fold changes, and minimum counts.
}
\examples{
library(cpam)

# load gene-only example cpam object
load(system.file("extdata", "cpo_example.rda", package = "cpam"))

results(cpo_example)

# Add filters
results(cpo_example, p_threshold = 0.01, min_lfc = 1)

}
