% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{print.summary.cowbell}
\alias{print.summary.cowbell}
\title{Prints the summary obtained by \code{\link{summary.cowbell}}.}
\usage{
\method{print}{summary.cowbell}(x, ...)
}
\arguments{
\item{x}{The object to print generated by \code{\link{summary.cowbell}}}

\item{...}{Just for compatibility purposes.}
}
\description{
The output states the concept consisting of the formula and the value range, that was given as a prior information.
Then follows the characteristics of the cowbell function. This is the minimal and maximal value of the dependent variable.
The maximum is reached at the plateau part and the minimal at the outer ring of the cowbell. It gets reached if
any of the two independent variables have reached their minimum. The R function with which the cowbell gets computed is then
appended. It follows the R squared and F-statistics in comparison with a constant function.
}
\details{
The following analysis is done to check the significance of the breakpoint. The breakpoint gets eliminated by removing
the plateau. The linear rising ridge of the cowbell is rised up to the specified maximum of the independent variables.
Therefore only the minimal and maximal value of the dependent variable is left of the definition. What follows is the
string that characterizes the R function and the R Squared of the used model. The following F-Statistics compares the
full model with the breakpoint against this reduced model without to estimate the significance of the breakpoint.

Implementation of the \code{\link{print}} generic.
}
\examples{
# Run a simplified anaylsis with 10 iterations only (to save time.)
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
data(allFun)
test<-generateCowbell(concept, allFun, 10)
summary(test)
}
