% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\docType{package}
\name{cowbell}
\alias{cowbell}
\alias{cowbell-package}
\title{Computes a response surface as segmented linear regression that resembles a cowbell.}
\description{
The application case for which this package has been constructed for is the response analysis
of one dependend variable that depends on two independend variable. Additionally a prior information is
given on the minimal and maximal values of those three variables. This is the case if those variables originate
from questions using Likert scales.
This information is indicated upfront with the function \code{\link{generateCowbellConcept}}.
The response surface resembles a quarter segment of a cowbell. It starts with a certain value at the
dependend variable if any of the independent variables are at their minimal value. If both independent variables
have reached their breakpoint value a new value with a plateau will be returned. Going to the plateau a rising linear
ridge is used. Where to both sides of the ridge there is only a linear dependency on one of the independent variables.
In general this model may be worth trying if one assumes that
there is a point of saturation for both independent variables and that up this point essentially the smaller one of both values
is determining the result on the dependend variable.
This is computed in a second step with the help of the
function \code{\link{generateCowbell}}.
}
