% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rd_df.R
\name{Rd_df}
\alias{Rd_df}
\title{Create a tabular representation of man file information}
\usage{
Rd_df(x)
}
\arguments{
\item{x}{A package object to coerce}
}
\value{
A \code{data.frame} of documented object information with variables:
\describe{
\item{index}{A \code{numeric} index of documentation files associated with
documentation objects}
\item{file}{A \code{character} filename of the Rd file in the "man" directory}
\item{filepath}{A \code{character} file path of the Rd file in the "man"
directory}
\item{alias}{\code{character} object names which are aliases for the
documentation in \code{filepath}}
\item{is_exported}{A \code{logical} indicator of whether the aliased object
is exported from the package namespace}
\item{doctype}{A \code{character} representing the Rd docType field.}
}
}
\description{
Provides Rd index info with a few additional columns of information about
each exported object. Returns one record per documented object, even if
multiple objects alias to the same documentation file.
}
\examples{
package_source_dir <- system.file("examplepkg", package = "covtracer")
Rd_df(package_source_dir)

}
