% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covsep.R
\name{projected_differences}
\alias{projected_differences}
\title{Compute the projection of the rescaled difference between the sample covariance
and its separable approximation onto the separable eigenfunctions}
\usage{
projected_differences(Data, l1 = 1, l2 = 1,
  with.asymptotic.variances = TRUE)
}
\arguments{
\item{Data}{a (non-empty) \code{N x d1 x d2} array of data values. The first
direction indices the \eqn{N} observations, each consisting of a \code{d1 x d2}
discretization of the surface, so that \code{Data[i,,]} corresponds to the
i-th observed surface.}

\item{l1}{number of eigenfunctions to be used in the first (row) dimension for the projection}

\item{l2}{number of eigenfunctions to be used in the second (column) dimension for the projection}

\item{with.asymptotic.variances}{logical variable; if TRUE, the function outputs the estimate asymptotic variances of the projected differences}
}
\value{
A list with
\describe{
 \item{T.N}{The projected differences}
\item{sigma.left}{The row covariances of \code{T.N}}
\item{sigma.right}{The column covariances of \code{T.N}}
}
}
\description{
Compute the projection of the rescaled difference between the sample covariance
and its separable approximation onto the separable eigenfunctions
}
\section{Details}{

The function computes the projection of the rescaled difference between the sample covariance
and its separable approximation onto the separable eigenfunctions \code{u_i
x v_j : i = 1, \ldots, l1; j = 1, \ldots, l2}.
}

\examples{
Data  <-  rmtnorm(30, C1, C2)
ans <- projected_differences(Data, l1=1, l2=2)
}
