% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softmax.R
\name{softmax}
\alias{softmax}
\title{Softmax Function with Special Handling for Infinite Values}
\usage{
softmax(x)
}
\arguments{
\item{x}{A numeric vector for which the softmax function will be calculated.}
}
\value{
A numeric vector of the same length as \code{x}, where the values represent probabilities summing to 1.
}
\description{
This function computes the softmax of a vector \code{x}, with special handling for infinite values.
The softmax function transforms input values into a probability distribution by exponentiating
each value, then normalizing by the sum of all exponentiated values.
The function ensures numerical stability, particularly when dealing with very large or very small values,
and handles cases where the values are infinite (\code{Inf}).
}
\examples{
softmax(c(10, 5, 2))
softmax(c(Inf, -Inf, 0))
softmax(c(-Inf, -Inf, -Inf))

}
