% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covKCD.r
\name{covKCD}
\alias{covKCD}
\title{Kronecker-core covariance decomposition}
\usage{
covKCD(S, p1, p2, tol = 1e-08)
}
\arguments{
\item{S}{a covariance matrix of dimension (p1p2)*(p1p2).}

\item{p1}{the row dimension.}

\item{p2}{the column dimension.}

\item{tol}{the convergence tolerance of the iterative algorithm.}
}
\value{
\code{covKCD} returns a list with the following elements: 
\describe{
\item{K}{the Kronecker covariance matrix;}
\item{C}{the core covariance matrix;}
\item{K1}{the row covariance matrix;}
\item{K2}{the column covariance matrix;} 
\item{div}{ the divergence between \code{S} and \code{K} across iterations of the algorithm.} 
}
}
\description{
Computes the Kronecker-core decomposition of a covariance matrix.
}
\details{
The Kronecker-core decomposition is a representation of an 
arbitrary covariance matrix S in terms of a separable 
Kronecker covariance 
matrix K and a complementary non-separable core covariance matrix
C. The Kronecker covariance is the separable covariance matrix
that is closest to S
in terms of the divergence function
\deqn{ \log|K| + \mbox{trace}(K^{-1}S).} 
The core covariance matrix 
C is computed from 
S and K via 
\deqn{ C = K^{-1/2} S K^{-1/2}.}
}
\examples{
p1<-4 ; p2<-3 ; n<-200

# create a matrix Y with separable covariance
A<-matrix(rnorm(p1*p1),p1,p1)  
B<-matrix(rnorm(p2*p2),p2,p2)/3
Y<-array(rnorm(n*p1*p2),dim=c(n,p1,p2))  
Y<-aperm( apply(Y,c(1,3),function(y){ A\%*\%y } ),c(2,1,3)) 
Y<-aperm( apply(Y,c(1,2),function(y){ B\%*\%y } ),c(2,3,1)) 

# covariance 
S<-mcov(Y) 

KCD<-covKCD(S,p1,p2) 

plot(A\%*\%t(A), KCD$K1)
plot(B\%*\%t(B), KCD$K2)

}
\author{
Peter Hoff
}
