% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_matrix.R
\name{correlation_matrix}
\alias{correlation_matrix}
\title{Creates a publication-ready / formatted correlation matrix, using \code{Hmisc::rcorr} in the backend.}
\usage{
correlation_matrix(
  df,
  type = "pearson",
  digits = 3,
  decimal.mark = ".",
  use = "all",
  show_significance = TRUE,
  replace_diagonal = FALSE,
  replacement = ""
)
}
\arguments{
\item{df}{dataframe; containing numeric and/or logical columns to calculate correlations for}

\item{type}{character; specifies the type of correlations to compute; gets passed to \code{Hmisc::rcorr}; options are \code{"pearson"} or \code{"spearman"}; defaults to \code{"pearson"}}

\item{digits}{integer/double; number of decimals to show in the correlation matrix; gets passed to \code{formatC}; defaults to \code{3}}

\item{decimal.mark}{character; which decimal.mark to use; gets passed to \code{formatC}; defaults to \code{.}}

\item{use}{character; which part of the correlation matrix to display; options are \code{"all"}, \code{"upper"}, \code{"lower"}; defaults to \code{"all"}}

\item{show_significance}{boolean; whether to add \code{*} to represent the significance levels for the correlations; defaults to \code{TRUE}}

\item{replace_diagonal}{boolean; whether to replace the correlations on the diagonal; defaults to \code{FALSE}}

\item{replacement}{character; what to replace the diagonal and/or upper/lower triangles with; defaults to \code{""} (empty string)}
}
\value{
a correlation matrix
}
\description{
Creates a publication-ready / formatted correlation matrix, using \code{Hmisc::rcorr} in the backend.
}
\examples{
correlation_matrix(iris)
correlation_matrix(mtcars)
}
