% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrBubble.R
\name{corrBubble}
\alias{corrBubble}
\title{corrBubble}
\usage{
corrBubble(
  mat,
  display = c("all", "upper", "lower"),
  pal = colorRampPalette(c("cornflowerblue", "white", "tomato"))(100)
)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{display}{A character vector specifying which part of the correlation
matrix to display: 'all', 'upper', or 'lower', default is 'all'.}

\item{pal}{A color palette for the bubble plot.}
}
\value{
An interactive bubble plot displaying correlations.
}
\description{
This function creates an interactive bubble plot of
correlations between variables in a dataset.
}
\details{
Creates an interactive bubble plot displaying correlation values. By hovering
mouse over a cell, the variables and correlation value is shown.
}
\examples{
cm <- cor(mtcars)

corrBubble(mat = cm,
           display = 'all')


}
