% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_cases.R
\name{corona_totals}
\alias{corona_totals}
\title{Plot total cases over time for a selected country.}
\usage{
corona_totals(
  country = "Italy",
  daystart = 60,
  dayend = 76,
  pdf = FALSE,
  log = FALSE,
  smooth = FALSE,
  prefix = ""
)
}
\arguments{
\item{country}{Text name of country (in owid frame)}

\item{daystart}{first day}

\item{dayend}{last day to plot}

\item{pdf}{TRUE will print value}

\item{log}{TRUE will take base 10 logarithm of y-axis values}

\item{smooth}{TRUE will try to fit linear model (use with logarithm)}

\item{prefix}{defaults to ''; a text value will be prefixed to PDF name \emph{after} country_ name.}
}
\description{
Defaults to Italy, as this was our demonstration.
Add a linear regression by specifying smooth=TRUE.
}
\examples{
corona_totals( country='Italy', daystart=60, dayend=76, log=TRUE, smooth=TRUE ) 
corona_totals(country='United Kingdom', log=TRUE, smooth=TRUE)
}
\keyword{cases}
\keyword{corona}
\keyword{country}
\keyword{total}
