% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conway.R
\name{corona_life}
\alias{corona_life}
\title{Animate Conway's Game of Life}
\usage{
corona_life(
  pattern = "soup",
  side = 50,
  steps = 100,
  density = 0.3,
  filename = NULL,
  wrap = TRUE,
  fps = 20,
  pause = 10
)
}
\arguments{
\item{pattern}{Defaults to 'soup' but there are many other well-known options:
blinker ttetromino rpentomino toad beehive
beacon clock pulsar pentadecathlon galaxy spaceship
glidergun piheptomino switchengine conway acorn rabbits
boring static patterns: block snake eater}

\item{side}{The number of elements on the area's side (width or height)}

\item{steps}{The number of frames}

\item{density}{0.0--1 The density of the initial, random items ('soup')}

\item{filename}{writes to this file name e.g. foo.gif (NULL for current GIF device)}

\item{wrap}{Wrap around}

\item{fps}{Frames per second}

\item{pause}{Initial pause}
}
\description{
The canvas (arena) wraps around vertically and horizontally!
Execution will take some time. Results will be viewed differently
depending on your system's default viewer for animated GIF files.
}
\examples{
\dontrun{
corona_life( filename='animation.gif', side=50, steps=500, density=0.2 ) 
corona_life( side=100, steps=1000, pattern='rpentomino', wrap=FALSE ) 
corona_life( side=30, steps=120, pattern='spaceship' ) 
corona_life( side=100, steps=400, pattern='switchengine' ) 
corona_life( side=20, steps=30, pattern='clock' ) 
corona_life( side=20, steps=30, pattern='galaxy' ) 
corona_life( side=100, steps=200, pattern='glidergun' ) 
corona_life( side=45, steps=130, pattern='conway', fps=8, pause=40)
}
}
\keyword{Conway}
\keyword{animation}
\keyword{corona}
\keyword{frames}
\keyword{game}
\keyword{life}
\keyword{of}
